/*
	HIMEMC.C
	
	commandline handling for HIMEM
	
	this stuff is copyrighted (c) by tom ehlert
	
	given to the FreeDOS project under GPL license	
	
*/

#define PROGRAM "HIMEM"

#include "useful.h"


extern char   far init_message[];
extern char   far vinit_message[];
extern char   far copyright[];
extern ushort far xms_num_handles;	/* default 72 */
extern char   far startup_verbose;
extern char   far xms_logging_enabled;
extern char   far no_above_16;
extern char   far x_option;
extern char   far alwayson_set,bios_set,ps2_set,fast_set,port92_set,kbc_set;
extern ulong far xms_max;



/* called on startup.
	handle commandline "NUMHANDLES=" ...
	...
	mode = 0 if called as driver
	mode = 1 if called as EXE
	
	return: 0         - everything fine
	        errorcode - exit code/abort driver
*/ 

int TheRealMain(int mode, char far *commandline)
{
	char far *found;
	int int15 = 0;
	
	if (mode == EXECMODE_EXE)
		startup_verbose = 1;
    
                             
	printf("%Fs", init_message); 
	printf(" ["__DATE__ "] ");
	printf("%Fs",copyright); 
	printf("\n");

	/******* commandline handling **********/
	
	if (FindCommand(commandline, "/VERBOSE", &found) )
		{ 
		startup_verbose = 1;
		}              
		
	if (FindCommand(commandline, "/LOG", &found) )
		{ 
		xms_logging_enabled = 1;
		}

	if (startup_verbose)
		{
		printf("%Fs\n",vinit_message);
		}

	if (FindCommand(commandline, "/NUMHANDLES=", &found) )
		{ 
		xms_num_handles = GetValue(found,10);
		if (startup_verbose)
			printf("selected num_handles=%d\n",xms_num_handles);

		if (xms_num_handles < 8)
			{
			printf("HIMEM:NUMHANDLES must be >= 8, corrected\n");
			xms_num_handles = 8;
			}			
			
		if (xms_num_handles > 128)
			{
			printf("HIMEM:NUMHANDLES must be <= 128, corrected\n");
			xms_num_handles = 128;
			}			
			
		}
		
		
	if (FindCommand(commandline, "/TESTMEM:ON", &found) ||
		FindCommand(commandline, "/TESTMEM:OFF", &found) )
		{
		if (startup_verbose)
			printf("/TESTMEM:ON|OFF not implemented - ignored\n");
		}
		

	if (FindCommand(commandline, "/NOABOVE16", &found) )
		{
			no_above_16 = 1;
		}

	if (FindCommand(commandline, "/X", &found) )
		{
			x_option = 1;
		}

	if (FindCommand(commandline, "/METHOD:ALWAYSON", &found) )
		{
			alwayson_set = 1;
		}

	if (FindCommand(commandline, "/METHOD:BIOS", &found) )
		{
			bios_set = 1;
		}

	if (FindCommand(commandline, "/METHOD:FAST", &found) )
		{
			fast_set = 1;
		}

	if (FindCommand(commandline, "/METHOD:PS2", &found) )
		{
			ps2_set = 1;
		}

	if (FindCommand(commandline, "/METHOD:PORT92", &found) )
		{
			port92_set = 1;
		}

	if (FindCommand(commandline, "/METHOD:KBC", &found) )
		{
			kbc_set = 1;
		}

	if (FindCommand(commandline, "/MAX=", &found) )
		{ 
		xms_max = GetValue(found,10);
		if (startup_verbose)
			printf("maximum XMS=%luK\n",xms_max);
		}
		

	if (FindCommand(commandline, "/INT15=", &found) )
		{ 
		int15 = (int)GetValue(found,16);
		
						/* you probably intended this something to do
						   so we warn (beep) */
		
		printf("\aHIMEM:/INT15=%x - not implemented\n",int15);
		}

	if (FindCommand(commandline, "/TEST", &found))
		{
		extern XMSTESTmain(void);
		
		XMSTESTmain();
		
		return 0;
		}


	if (FindCommand(commandline, "/KILL64", &found))
		{
		extern XMSKILL64(void);
		
		XMSKILL64();
		
		return 0;
		}


	/******* commandline handling done, are there remainders **********/

	commandline = skipWhite(commandline);

	if (*commandline)
		printf("ignored commandline <%Fs>\n", commandline);



	if (mode == EXECMODE_EXE)
		{
							/* called as exe from commandline 
								do :
									usage info
									status report
									show memory statistic
									...
							*/
							
		printf("\n" 
				"HIMEM.EXE is a devicedriver and must be loaded in CONFIG.SYS\n"
				"please load HIMEM as DEVICE=HIMEM.EXE in config.sys\n"
				"\n");

		printf("commandline options available\n"
		       "   /NUMHANDLES=72  (default = 72, min = 8, max=128)\n"
		       "   /VERBOSE         more (debug) ouput during installation\n"
		       "   /MAX:#####       limit memory controlled by HIMEM to #####K\n"
			   "   /METHOD:ALWAYSON specify A20 control method\n"
			   "          :BIOS\n"
			   "          :FAST\n"
			   "          :PS2\n"
			   "          :KBC\n"
			   "          :PORT92\n"
		       "   /NOABOVE16       don't use function E801h to detect >64M\n"
		       "   /X               don't use function E820h to detect >64M\n"
		       "   /TEST - tests all memory + checks the loaded XMS implementation\n"
		       "   /LOG\n"
				);				
				
		return 1;
		}											



	return 0;			/* driver can't fail */

}

 