

/* #define _IODEBUG 1 */
/* #define _IORDEBUG 1 */


/* io.c  -  Virtual disk input/output */

/* Written 1993 by Werner Almesberger */

/*
 * Thu Feb 26 01:15:36 CET 1998: Martin Schulze <joey@infodrom.north.de>
 *	Fixed nasty bug that caused every file with a name like
 *	xxxxxxxx.xxx to be treated as bad name that needed to be fixed.
 */

/* FAT32, VFAT, Atari format support, and various fixes additions May 1998
 * by Roman Hodek <Roman.Hodek@informatik.uni-erlangen.de> */

/* connection to the sector-based DOS disk driver by Eric Auer 2002 */
/* for the beginning, only READING is supported and only FAT12/16   */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <fcntl.h>
#ifndef __DJGPP__
#include <linux/fd.h>
#else
/* *** #include "inc/fd.h" seems not to be used anyway *** */
#endif


#include "dosfsck.h"
#include "common.h"
#include "io.h"


typedef struct _change {
    void *data;
    loff_t pos;
    int size;
    struct _change *next;
} CHANGE;

#ifdef __DJGPP__
static int drive = -1;	/* drive number, >= 0 activates DOS driver */
#include <io.h>         /* _flush_disk_cache() */
#include "rawio.h"	/* *** raw_write() and raw_read() - Eric *** */
#endif


static CHANGE *changes,*last;
static int fd,did_change = 0;

unsigned device_no;

/* ********************************************************** */

/* Use the _llseek system call directly, because there (once?) was a bug in
 * the glibc implementation of it. */
/* *** #include <linux/unistd.h> *** */
#if defined(__alpha) || defined (__ia64__) || defined (__DJGPP__) /* *** *** */
/* On alpha, the syscall is simply lseek, because it's a 64 bit system. */

static loff_t llseek( int fd, loff_t offset, int whence )
{
/* *** *** */
#ifdef _IORDEBUG
#ifdef __DJGPP__
    printf("Dos lseek(fd=%d, offset=%lld, whence=%d)\n", fd, offset, whence);
#else
    printf("64bit lseek(fd=%d, offset=%lld, whence=%d)\n", fd, offset, whence);
#endif
#endif
/* *** *** */ 
	/* *** ONLY used for images, NEVER for disks anyway *** */
        return lseek(fd, offset, whence);
}
#else
#include <linux/unistd.h> /* *** *** */
# ifndef __NR__llseek
# error _llseek system call not present
# endif
static _syscall5( int, _llseek, uint, fd, ulong, hi, ulong, lo,
		  loff_t *, res, uint, wh );

static loff_t llseek( int fd, loff_t offset, int whence )
{
    loff_t actual;

/* *** *** */
#ifdef _IORDEBUG
    printf("Linux llseek(fd=%d, offset=%lld, whence=%d)\n", fd, offset, whence);
#endif
/* *** *** */
    if (_llseek(fd, offset>>32, offset&0xffffffff, &actual, whence) != 0)
	return (loff_t)-1;
    return actual;
}
#endif

/* ********************************************************** */

void fs_open(char *path,int rw)
{
    struct stat stbuf;
    
/* *** *** */
#ifdef _IODEBUG
    printf("fs_open(path='%s', rw=%d) =", path, rw);
#endif
/* *** *** */
#ifndef __DJGPP__
    if ((fd = open(path,rw ? O_RDWR : O_RDONLY)) < 0)
	pdie("open %s",path);
#else
              /* *** sigh... DOS has text and binary modes... *** */
    if ((path[1] == ':') &&
        (path[2] ==  0 )) {       /* *** have a drive letter? *** */
        drive = path[0] - 'A';               /* A: is 0 and so on */
        drive = (drive >= 32) ? (drive - 32) : drive; /* case fix */
        /* no further action taken yet, will notice errors later! */
        fd = -1;
    } else {
        drive = -1;
        if ((fd = open(path,(rw ? O_RDWR : O_RDONLY) | O_BINARY)) < 0)
	    pdie("open %s",path);
    }
#endif
    changes = last = NULL;
    did_change = 0;

    if (drive < 0) { /* *** */
        if (fstat(fd,&stbuf) < 0)
	    pdie("fstat",path);
    }
#ifndef __DJGPP__
    device_no = S_ISBLK(stbuf.st_mode) ? (stbuf.st_rdev >> 8) & 0xff : 0;
#else
    /* *** used by boot.c: 2 means it is FAT12 if it looks so... *** */
    device_no = 2;
#endif
/* *** *** */
#ifdef _IODEBUG
    printf("%d [dsk=%d]\n", fd, drive);
#endif
/* *** *** */
}

/* ********************************************************** */

void fs_read(loff_t pos,size_t size,void *data)
{
    CHANGE *walk;
    ssize_t got;

/* *** *** */
#ifdef _IORDEBUG
/*
    printf("fs_read(pos=%lld, size=%ld, *data=0x%p)\n", pos, size, data);
*/
#endif
/* *** *** */
    if (drive >= 0) {
        raw_read(pos, size, data); /* *** */
    } else {
        if (llseek(fd,pos,0) != pos) pdie("Seek to %lld",pos);
        if ((got = read(fd,data,size)) < 0) pdie("Read %d bytes at %lld",size,pos);
        if (got != size) die("Got %d bytes instead of %d at %lld",got,size,pos);
    }
    for (walk = changes; walk; walk = walk->next) {
	if (walk->pos < pos+size && walk->pos+walk->size > pos) {
	    if (walk->pos < pos)
		memcpy(data,(char *) walk->data+pos-walk->pos,min(size,
		  walk->size-pos+walk->pos));
	    else memcpy((char *) data+walk->pos-pos,walk->data,min(walk->size,
		  size+pos-walk->pos));
	}
    }
}

/* ********************************************************** */

int fs_test(loff_t pos,size_t size)
{
    void *scratch;
    int okay;

/* *** *** */
#ifdef _IORDEBUG
    printf("fs_test(pos=%lld, size=%ld)\n", pos, size);
#endif
/* *** *** */
    if (drive >= 0) {
        scratch = alloc(size);
        raw_read(pos, size, scratch); /* *** */
    } else {
        if (llseek(fd,pos,0) != pos) pdie("Seek to %lld",pos);
        scratch = alloc(size);
        okay = read(fd,scratch,size) == size;
    }
    free(scratch);
    return okay;
}

/* ********************************************************** */

void fs_write(loff_t pos,size_t size,void *data)
{
    CHANGE *new;
    int did;

/* *** *** */
#ifdef _IODEBUG
    printf("fs_write(pos=%lld, size=%ld, data=0x%p)\n", pos, size, data);
#endif
/* *** *** */
    if (write_immed) {
	did_change = 1;
	if (drive >= 0) {
	    raw_write(pos, size, data); /* *** */
	} else {
	    if (llseek(fd,pos,0) != pos) pdie("Seek to %lld",pos);
	    if ((did = write(fd,data,size)) == size) return;
	    if (did < 0) pdie("Write %d bytes at %lld",size,pos);
	    die("Wrote %d bytes instead of %d at %lld",did,size,pos);
	}
    }
    new = alloc(sizeof(CHANGE));
    new->pos = pos;
    memcpy(new->data = alloc(new->size = size),data,size);
    new->next = NULL;
    if (last) last->next = new;
    else changes = new;
    last = new;
}

/* ********************************************************** */

static void fs_flush(void)
{
    CHANGE *this;
    int size;

/* *** *** */
#ifdef _IODEBUG
    printf("fs_flush()\n");
#endif
/* *** *** */
    while (changes) {
	this = changes;
	changes = changes->next;
	if (drive >= 0) {
	    raw_write(this->pos, this->size, this->data); /* *** */
	} else {
	    if (llseek(fd,this->pos,0) != this->pos)
		fprintf(stderr,"Seek to %lld failed: %s\n  Did not write %d bytes.\n",
		        this->pos,strerror(errno),this->size);
	    else if ((size = write(fd,this->data,this->size)) < 0)
		fprintf(stderr,"Writing %d bytes at %lld failed: %s\n",this->size,
			this->pos,strerror(errno));
	    else if (size != this->size)
		fprintf(stderr,"Wrote %d bytes instead of %d bytes at %lld."
		        "\n",size,this->size,this->pos);
	}
	free(this->data);
	free(this);
    }
}

/* ********************************************************** */

int fs_close(int write)
{
    CHANGE *next;
    int changed;

/* *** *** */
#ifdef _IODEBUG
    printf("fs_close(write=%d)\n", write);
#endif
/* *** *** */
    changed = !!changes;
    if (write) fs_flush();
    else while (changes) {
	    next = changes->next;
	    free(changes->data);
	    free(changes);
	    changes = next;
	}
    if (drive >= 0) {
        sync();	/* commit file data */ /* *** */
#ifdef __DJGPP__
        _flush_disk_cache(); /* flush disk cache */ /* *** */
#endif
    } else {
        if (close(fd) < 0) pdie("closing file system");
    }
    return changed || did_change;
}

/* ********************************************************** */

int fs_changed(void)
{
    return !!changes || did_change;
}

/* Local Variables: */
/* tab-width: 8     */
/* End:             */
