/*

    File: chgtype.c

    Copyright (C) 1998-2004 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>	/* geteuid */
#include "types.h"
#include "common.h"
#include "lang.h"
#include "intrface.h"
#include "fnctdsk.h"

extern char* nom_os[256];
int change_part_type(const t_param_disk *disk_car,t_diskext *partition)
{
  char response[100];
  int nbr=0;
  int i;
  aff_buffer(BUFFER_RESET,"Q");
  aff_buffer(BUFFER_ADD,"List of partition type\n");
  for(i=0;i<=255;i++)
  {
    if(nom_os[i]!=NULL && strcmp(nom_os[i],"reserved")!=0)
    {
      aff_buffer(BUFFER_ADD,"%02x %-20s ",i,nom_os[i]);
      nbr++;
      if(nbr==3)
      {
	nbr=0;
	aff_buffer(BUFFER_ADD,"\n");
      }
    }
  }
  aff_copy(stdscr);
  wmove(stdscr,4,0);
  aff_part(stdscr,AFF_PART_NONL,disk_car,partition);
  aff_buffer(BUFFER_DISPLAY,"Q",stdscr);
  wmove(stdscr,23,0);
  wdoprintf(stdscr,"New partition type [current %02x] ?",partition->part_type);
  if (get_string(response, sizeof(response), NULL) > 0) {
    int tmp_val = strtol(response, NULL, 16);
    if ((tmp_val > 0) && (tmp_val <= 255) && (is_extended(tmp_val)==0))
      partition->part_type = tmp_val;
  }
  return 0;
}


