# FORCE_EFI_BOOT

echo -off
# +
# + ============================================================== +
#  Copyright (c) 2019, Intel Corporation.

#  This source code and any documentation accompanying it ("Material") is furnished
#  under license and may only be used or copied in accordance with the terms of that
#  license.  No license, express or implied, by estoppel or otherwise, to any
#  intellectual property rights is granted to you by disclosure or delivery of these
#  Materials.  The Materials are subject to change without notice and should not be
#  construed as a commitment by Intel Corporation to market, license, sell or support
#  any product or technology.  Unless otherwise provided for in the license under which
#  this Material is provided, the Material is provided AS IS, with no warranties of
#  any kind, express or implied, including without limitation the implied warranties
#  of fitness, merchantability, or non-infringement.  Except as expressly permitted by
#  the license for the Material, neither Intel Corporation nor its suppliers assumes
#  any responsibility for any errors or inaccuracies that may appear herein.  Except
#  as expressly permitted by the license for the Material, no part of the Material
#  may be reproduced, stored in a retrieval system, transmitted in any form, or
#  distributed by any means without the express written consent of Intel Corporation.

#  Module Name:  Startup.nsh

#  Abstract:  UEFI Script file for invoking system software updates for 
#  Intel(R) Server Board S2600WF Family.

# + ============================================================== +
#    Program all blocks of BIOS from capsule file 
# + ============================================================== +

@echo -off
mode 80 25
:foundimage section is simply to locate the correct drive

if exist .\ipmi.efi then
 goto FOUNDIMAGE
endif
if exist fs0:\ipmi.efi then
 fs0:
 echo Found Update Packages on fs0:
 goto FOUNDIMAGE
endif
if exist fs1:\ipmi.efi then
 fs1:
 echo Found Update Packages on fs1:
 goto FOUNDIMAGE
endif
if exist fs2:\ipmi.efi then
 fs2:
 echo Found Update Packages on fs2:
 goto FOUNDIMAGE
endif
 echo "Unable to find Update Packages".  
 echo "Please mount the drive with the update package".
 echo ""
 goto END
:FOUNDIMAGE



echo "============================================================================================"
echo " "
echo "This utility will update the BMC firmware, system BIOS, ME firmware, FD, FRUSDR and DCPMM FW"
echo " "
echo "      - Intel(R) Server Board S2600WF Family"
echo " "
echo "If you have not read the Readme and Update Instructions,"
echo "it is highly advisable you do that before continuing with this update."
echo " "
echo "During the full update process, the system will reboot several times."
echo "Do NOT power off the system or remove the USB flash drive at any time during"
echo "this process. Doing so may render your system inoperable."
echo " "
echo "Please make sure no *pass.txt exist in USB key before starting update process"
echo " "
echo "For firmware updates and troubleshooting tips, visit https://www.intel.com/support/serverbios"
echo " "
echo "============================================================================================="

# Notification
     echo " Checking your current code levels for compatibility with this SUP. "
     echo " .............................Please wait......................................"
     echo "Reading Current FW on board..."
     iflash32.efi -i
	 

echo " "
echo "======================================================================="
echo "Current Update Sequence is as below"
echo "1. BMC - No reset after update completeness"
echo "2. BIOS - No reset after update completeness"
echo "3. ME - No reset after update completeness"
echo "4. FD - No reset after update completeness"
echo "5. FRUSDR - Automatically reset after update completeness"
echo " "
echo "!!!Item1 to Item5 will be completed for 1st time startup.nsh invoked!!!"
echo " "
echo "6. DCPMM FW if DCPMM DIMM installed - No reset after update completeness, will remind user to manually reset platform after completeness"
echo " "
echo "!!!Item6 will be completed for 2nd time startup.nsh invoked!!!"
echo " "
echo "See the Readme and Update Instructions file for additional information."
echo " "
echo "======================================================================="

pause


:A
if exist BMC_pass.txt then 
	
	if exist BIOS_pass.txt then 
		
		if exist ME_pass.txt then 
			
			if exist FD_pass.txt then 
				
				if exist Frusdr_pass.txt then
					
					comp firstresettemplate.log reset.log
					if %lasterror% == 0 then
						echo "SUT reboot successfully after BIOS/BMC/FRUSDR update."
						stall 10000000
					else
						echo "SUT will auto reboot later for BIOS/BMC/FRUSDR taking effect."
						stall 10000000
						echo 1 >> reset.log
						reset -c
					endif
								
					if exist ipmctl.efi then
						
						ipmctl.efi show -dimm > nodcpmm.txt
						comp nodcpmm.log nodcpmm.txt
						if %lasterror% == 0 then
							echo " "
							echo "No DCPMM DIMM installed, Ignore DCPMM FW Update" 
							echo " "
							goto final
						else
							
							echo " "
							echo "Found DCPMM DIMM installed"
							echo "Start to proceed DCPMM FW Update"
							echo " "
							stall 10000000
							goto DCPMMFW
						endif
					else
						echo "There don't have ApachePass management tool"
						goto final
					endif
					
				else
					goto FRUSDR
				endif
				
			else
				goto FD
			endif
			
		else 
			goto ME
		endif
	
	else 
		goto BIOS
	endif
		
else
	goto BMC
endif



:BMC

echo " "
echo "==============================================================================="
echo "Continuing BMC firmware update......"
echo "DO NOT remove the USB flash drive"
echo " "
echo " "

fwUpdateBMC.nsh

echo " "
echo "BMC Firmware update has completed" > BMC_pass.txt
echo " "
stall 6000000
goto A


:BIOS

echo " "
echo "==============================================================================="
echo "Continuing system BIOS update......"
echo "DO NOT remove the USB flash drive"
echo " "
echo " "

updBios.nsh

echo " "
echo "BIOS Firmware update has completed" > BIOS_pass.txt
echo " "
stall 6000000
goto A


:ME

echo " "
echo "==============================================================================="
echo "Continuing ME firmware update......"
echo "DO NOT remove the USB flash drive"
echo " "
echo "==============================================================================="
echo " "
echo " "

UpdMe.nsh

echo " "
echo "ME Firmware updates have completed" > ME_pass.txt
echo " "
echo
stall 6000000
goto A


:FD

echo " "
echo "==============================================================================="
echo "Continuing Flash Descriptor update......"
echo "DO NOT remove the USB flash drive"
echo " "
echo " "

updFD.nsh

echo " "
echo "Flash Descriptor update has completed" > FD_pass.txt
echo " "
echo "==============================================================================="
echo "DO NOT remove the USB flash drive"
echo " "
echo "==============================================================================="
stall 6000000
goto A


:FRUSDR

echo " "
echo "==============================================================================="
echo "Continuing System FRUSDR data update......"
echo "DO NOT remove the USB flash drive"
echo " "
echo " "

updS2600WFT.nsh

echo " "
echo "System FRU & SDR data have successfully been updated" > Frusdr_pass.txt
echo " "
goto A


:DCPMMFW

echo " "
echo "==============================================================================="
echo "Continuing DCPMM Firmware update......"
echo " "
echo "DO NOT remove the USB flash drive"
echo " "

UpdateDCPMM.nsh

echo " "
echo " "
stall 6000000


:final
del BMC_pass.txt
del BIOS_pass.txt
del ME_pass.txt
del FD_pass.txt
del Frusdr_pass.txt
del reset.log
del nodcpmm.txt


echo " "
echo "============================================================"
echo "All system updates have now completed"
echo " "
echo "Please note that this update process will raise the "
echo "log for BMC/BIOS/ME/FD flash"
echo "You can now remove the USB Key and reboot the system. During POST access the"
echo "BIOS Setup utility <f2> to confirm all updates have installed properly."


:END
 